// AIbufferDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AIbuffer.h"
#include "AIbufferDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAIbufferDlg dialog

CAIbufferDlg::CAIbufferDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAIbufferDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAIbufferDlg)
	m_samples = 0;
	m_burstMode = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAIbufferDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAIbufferDlg)
	DDX_Control(pDX, IDC_LIST2, m_chan1);
	DDX_Control(pDX, IDC_START, m_startButton);
	DDX_Control(pDX, IDC_LIST1, m_readList);
	DDX_Text(pDX, IDC_SAMPLES, m_samples);
	DDV_MinMaxUInt(pDX, m_samples, 2, 65535);
	DDX_Check(pDX, IDC_BURSTMODE, m_burstMode);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAIbufferDlg, CDialog)
	//{{AFX_MSG_MAP(CAIbufferDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_QUIT, OnQuit)
	ON_BN_CLICKED(IDC_START, OnStart)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAIbufferDlg message handlers

BOOL CAIbufferDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_pSR=NULL;
	m_driverInstance=NULL;

	m_samples=24; // give edit box on dialog an initial value
	UpdateData(FALSE);

	m_logicalDevice=0; //device number from DLinx Config Channel
	m_logicalChannel=0; //Which Analog Input Channel
	
	m_DLmsg=RegisterWindowMessage(DL_MESSAGE); //need to register DriverLINX messages to detect buffer filled message
	m_driverInstance=OpenDriverLINX(m_hWnd,"kdastc"); //Open DriverLINX driver, and bring up the dialog box to pick a driver
	// in above line, fill in "" with drier name to avoid the OpenDriverLINX dialog
	// for KPCI-3101/2/3/4 or KPCI-3116, KPCI-3110 driver name is kpci3100
	// for KPCI-3107/8 driver name is kpci3108
	// for KPCI-180xHC, driver name is kpci1800
	// for DAS-1800 products, driver name is kmb1800
	// for DAS-800 products, driver name is kmb800
	m_pSR=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
	memset(m_pSR,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
	DL_SetServiceRequestSize(*m_pSR); //Need to set the service request size member
	m_pSR->device=m_logicalDevice; //set the device number to the device being used
	m_pSR->operation=INITIALIZE; //Need to initialize the device before we can use it
	m_pSR->subsystem=DEVICE;  //the initialize function is part of the DEVICE subsystem
	m_pSR->mode=OTHER;  //Initialize is not a polled, interrupt, or dma operation, so we use OTHER
	m_pSR->hWnd=m_hWnd;  //Need to set the hWnd member to the window handle of the application
	DriverLINX(m_pSR); //Execute the initialize service
	showMessage(m_pSR); //show any errors
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAIbufferDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAIbufferDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAIbufferDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
	return;
}

void CAIbufferDlg::OnQuit() 
{
	// TODO: Add your control notification handler code here
	clearBuffers(); //de-allocate any existing buffers
	CloseDriverLINX(m_driverInstance); //close the DriverLINX driver
	m_driverInstance=NULL; //for safety, make sure m_driverInstance isn't pointing to anything
	delete(m_pSR); //de-allocate the memory used by the service request
	m_pSR=NULL;
	OnOK(); //Close the application
	
}

void CAIbufferDlg::OnStart() 
{
	m_readList.ResetContent(); //clear the listbox for chan 0
	m_chan1.ResetContent();  // clear list box for chan 1

	// TODO: Add your control notification handler code here
	clearBuffers();	//de-allocate any exisiting buffers in the service request
	m_pSR->operation=START; //Start the acquisition
	m_pSR->subsystem=AI; //using the AI subsystem
	m_pSR->mode=INTERRUPT; 
	m_pSR->start.typeEvent=COMMAND; //start on command
	m_pSR->timing.typeEvent=RATEEVENT; //timing will be determined by the rate generator
	m_pSR->stop.typeEvent=TCEVENT; //Stop on terminal count
	m_pSR->channels.nChannels=2; //Does NOT mean 2 channels; a start and stop channel will be provided
	m_pSR->channels.chanGain[0].channel=0; //start on channel 0
	m_pSR->channels.chanGain[1].channel=1; // stop on channel 1
	/*
		First gain pertains to start channel only.  Second gain pertains
		to all other channels in the start/stop range.

		Pass in a gain of 0 if you want the settings in the DriverLINX
		Configuration Panel (Special button) to be used, e.g., what 
		T/C type, units, use CJC or not, how many samples to average
		per reported reading.

		Or you can programatically set these values with a complex
		use of the gain field:

		'     -32768 + 5 = B Type T/C Sensor
'     -32768 + 6 = E Type T/C Sensor
'     -32768 + 7 = J Type T/C Sensor
'     -32768 + 8 = K Type T/C Sensor
'     -32768 + 9 = R Type T/C Sensor
'     -32768 + 10 = S Type T/C Sensor
'     -32768 + 11 = T Type T/C Sensor
'     -32768 + 13 = N Type T/C Sensor
'
'     1x2^13 = 8192 = CJC On
'     0x2^13 = 0 = CJC Off
'
'     1x2^14 = 16384 = report in deg F
'     0x2^14 = 0 = report in deg C
'
'     n*2^6 = n*64 = average n measurements with each reported reading

    */
	m_pSR->channels.chanGain[0].gainOrRange =  -32768 + 7 + 8192 + 0x2^14 + (2 * 64);
                             // type J + CJC + C or F + avg 1 per report 
	   
	m_pSR->channels.chanGain[1].gainOrRange=  -32768 + 7 + 8192 + 0x2^14 + (2 * 64);

	m_pSR->channels.numberFormat=tNATIVE; //use the native format (integer counts)
	

	/* read in m_samples from the dialog
	
	   Employ some logic to determine how many buffers to allocate depending
	   on how much data are requested

       Limits on buffering:  255 total buffers
	                         4B samples per buffer
							 But the CONVERT operation is limited to 65K samples
							 so recommend to not make buffers larger than
							 can be converted easily with CONVERT operation.




	*/
	UpdateData(TRUE);  // get new value from the dialog for m_samples
	m_pSR->lpBuffers=(DL_BUFFERLIST*) new BYTE[DL_BufferListBytes(1)]; //create a buffer list pointer for one buffer
	m_pSR->lpBuffers->bufferSize=Samples2Bytes(m_logicalDevice,AI,m_logicalChannel,m_samples); //set the size of the buffer (in bytes) to hold the number of samples
	// we want to acquire a buffer of data
	m_pSR->lpBuffers->notify=NOTIFY; //enable the buffer filled message
	m_pSR->lpBuffers->nBuffers=1; //use only one buffer
	m_pSR->lpBuffers->BufferAddr[0]=BufAlloc(GBUF_INT,m_pSR->lpBuffers->bufferSize); //Allocate Buffer 0 based on the size we just specified
	m_pSR->lpBuffers->bufferSize=Samples2Bytes(m_logicalDevice,AI,m_logicalChannel,m_samples); //set the size of the buffer (in bytes) to hold the number of samples
	
	m_pSR->timing.u.rateEvent.channel=DEFAULTTIMER; //DEFAULTTIMER is a symbol representing the default counter/timer channel used for pacing.
	m_pSR->timing.u.rateEvent.clock= INTERNAL1;
	m_pSR->timing.u.rateEvent.gate=DISABLED; //no gating will be used
	// max sample rate supported by DAS-TC/B is 2Hz.  If using Burst mode, the bursts can 
	// be at 25Hz max.
	m_pSR->timing.u.rateEvent.period=Sec2Tics(m_logicalDevice,AI,INTERNAL1,0.5f); //2Hz
	if (m_burstMode == FALSE)
	{
		m_pSR->timing.u.rateEvent.mode=RATEGEN; //or set to BURSTGEN and then program onCount and pulses
	    m_pSR->timing.u.rateEvent.pulses=0; //pulses sets the number of rate pulses to generate.
	    m_pSR->timing.u.rateEvent.onCount=0;  // how fast to execute burst mode
	}
	else
	{
		m_pSR->timing.u.rateEvent.mode=BURSTGEN; //or set to BURSTGEN and then program onCount and pulses
	    m_pSR->timing.u.rateEvent.pulses=2; //set equal to how many channels in the scan
	    m_pSR->timing.u.rateEvent.onCount=Sec2Tics(m_logicalDevice,AI,INTERNAL1,0.04f);  // how fast to execute burst mode
		             // 25Hz is max burst rate

	}
	if (DriverLINX(m_pSR) == NoErr)  //Execute the service request to start the acquisition
	{
		m_startButton.EnableWindow(FALSE); //Disable the start button at the beginning, so it doesn't get restarted in the middle of the acquisition
	}
	else
	{	
	showMessage(m_pSR); //show any errors
	}
	/*See the WindowProc function to see what happens next*/
}

void CAIbufferDlg::clearBuffers()
{
	/*Make sure the service request exists first, otherwise bad things
	happen if we try to act on a pointer which may be pointing anywhere*/
	if(m_pSR!=NULL)
	{
		/*If the service request exists, make sure there is a buffer list,
		for the same reason*/
		if(m_pSR->lpBuffers!=NULL)
		{
			/*If the buffer list exists, is there actually a pointer to
			a buffer?*/
			if(m_pSR->lpBuffers->BufferAddr[0]!=NULL)
			{
				/*De-allocate the buffer, and clear its pointer*/
				BufFree(m_pSR->lpBuffers->BufferAddr[0]);
				m_pSR->lpBuffers->BufferAddr[0]=NULL;
			}
			/*Delete the buffer list, we don't need it anymore*/
			delete(m_pSR->lpBuffers); 
			m_pSR->lpBuffers=NULL;
		}
	}
}

LRESULT CAIbufferDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(message==m_DLmsg) //Did DriverLINX post a message?  We only want to act on the DriverLINX buffer filled message
	{
		switch(wParam)
		{
		case DL_BUFFERFILLED: //Was the DriverLINX message the buffer filled message?
			done(); //if so, call the done() function to process the results
			break;
		}
	}

	return CDialog::WindowProc(message, wParam, lParam);
}

void CAIbufferDlg::done()
{
	float *readings;
	readings = new float[m_samples]; //make a temporary array to hold the converted readings
	CString str; //The CString class includes a format method to convert float to CString to display them in the listbox
	DWORD index;
	/*The convert operation used here is taking advantage of the fact
	that the logical device number and the subsystem (AI) have already
	been set in the start request*/
	m_pSR->operation=CONVERT; //Use the convert operation to convert the raw counts in the buffer to voltages
	m_pSR->mode=OTHER;  //Convert is not a polled, interrupt, or DMA operation
	m_pSR->start.typeEvent=DATACONVERT; //Set the start type to convert the data
	m_pSR->start.u.dataConvert.startIndex=0; //start at index 0 of the buffer
	m_pSR->start.u.dataConvert.nSamples=m_samples; //set the number of samples to convert
	m_pSR->start.u.dataConvert.numberFormat=tSINGLE; //convert the counts to tSINGLE (float)
	m_pSR->start.u.dataConvert.scaling=0.0f; //no scaling will be used
	m_pSR->start.u.dataConvert.offset=0.0f; //no offset will be applied
	m_pSR->start.u.dataConvert.wBuffer=0; //convert DriverLINX buffer 0, since that's the only one being used
	m_pSR->start.u.dataConvert.lpBuffer=readings; //put the converted readings in the temporary buffer
	DriverLINX(m_pSR); //Execute the conversion
	showMessage(m_pSR); //show any errors
	
		for(index=0;index<m_samples/2;index++)
		{
		// get index 0, 2, 4, 6, etc.
		str.Format("%8.3f",readings[2*index]); //format the float reading into a string for each reading
		m_readList.AddString(str); //Add the string to the chan0 listbox
		// get index 1, 3, 5, 7, etc.
		str.Format("%8.3f",readings[2*index+1]); //format the float reading into a string for each reading
		m_chan1.AddString(str); //Add the string to the chan1 listbox
		}

	UpdateData(FALSE); //Update the listbox display
	m_startButton.EnableWindow(TRUE); //re-enable the start button
	delete [] readings; //clear the temporary buffer so we don't have memory leaks when we run it again
	/*See the OnQuit() function to see what happens what needs to be done
	when the application closes*/
}
